/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.block.entity.table;

import io.github.fabricators_of_create.porting_lib.event.common.ItemCraftedCallback;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3956;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.worktable.IModifierWorktableRecipe;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.shared.inventory.ConfigurableInvWrapperCapability;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.block.entity.inventory.LazyResultContainer;
import slimeknights.tconstruct.tables.block.entity.inventory.ModifierWorktableContainerWrapper;
import slimeknights.tconstruct.tables.block.entity.table.RetexturedTableBlockEntity;
import slimeknights.tconstruct.tables.menu.ModifierWorktableContainerMenu;

public class ModifierWorktableBlockEntity
extends RetexturedTableBlockEntity
implements LazyResultContainer.ILazyCrafter {
    public static final int TINKER_SLOT = 0;
    public static final int INPUT_START = 1;
    public static final int INPUT_COUNT = 2;
    private static final class_2561 NAME = TConstruct.makeTranslation("gui", "modifier_worktable");
    private final LazyResultContainer craftingResult;
    private final ModifierWorktableContainerWrapper inventoryWrapper;
    private Boolean recipeValid;
    @Nullable
    private IModifierWorktableRecipe lastRecipe;
    @Nonnull
    private List<ModifierEntry> buttons = Collections.emptyList();
    private int selectedModifierIndex = -1;
    @Nullable
    private ToolStack result = null;
    private class_2561 currentMessage = class_2561.method_43473();

    public ModifierWorktableBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)TinkerTables.modifierWorktableTile.get(), pos, state, NAME, 3);
        this.itemHandler = new ConfigurableInvWrapperCapability((class_1263)this, false, false);
        this.inventoryWrapper = new ModifierWorktableContainerWrapper(this);
        this.craftingResult = new LazyResultContainer(this);
    }

    public void selectModifier(int index) {
        List<ModifierEntry> list;
        this.result = null;
        this.craftingResult.method_5448();
        if (index >= 0 && index < (list = this.getCurrentButtons()).size()) {
            this.selectedModifierIndex = index;
            ModifierEntry entry = list.get(index);
            assert (this.lastRecipe != null);
            RecipeResult<ToolStack> recipeResult = this.lastRecipe.getResult(this.inventoryWrapper, entry);
            if (recipeResult.isSuccess()) {
                this.result = recipeResult.getResult();
                this.currentMessage = class_2561.method_43473();
            } else {
                this.currentMessage = recipeResult.hasError() ? recipeResult.getMessage() : this.lastRecipe.getDescription(this.inventoryWrapper);
            }
            return;
        }
        this.selectedModifierIndex = -1;
        this.currentMessage = this.recipeValid == Boolean.TRUE && this.lastRecipe != null ? this.lastRecipe.getDescription(this.inventoryWrapper) : class_2561.method_43473();
    }

    public int getSelectedIndex() {
        return this.selectedModifierIndex;
    }

    private void syncRecipe() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.syncToRelevantPlayers(x$0 -> this.syncScreen((class_1657)x$0));
        }
    }

    public IModifierWorktableRecipe updateRecipe(IModifierWorktableRecipe recipe) {
        this.lastRecipe = recipe;
        this.recipeValid = true;
        this.currentMessage = this.lastRecipe.getDescription(this.inventoryWrapper);
        this.buttons = recipe.getModifierOptions(this.inventoryWrapper);
        this.selectModifier(-1);
        return recipe;
    }

    @Nullable
    public IModifierWorktableRecipe getCurrentRecipe() {
        if (this.recipeValid == Boolean.TRUE) {
            return this.lastRecipe;
        }
        if (this.recipeValid == null && this.field_11863 != null) {
            if (this.lastRecipe != null && this.lastRecipe.matches(this.inventoryWrapper, this.field_11863)) {
                return this.updateRecipe(this.lastRecipe);
            }
            Optional recipe = this.field_11863.method_8433().method_8132((class_3956)TinkerRecipeTypes.MODIFIER_WORKTABLE.get(), (class_1263)this.inventoryWrapper, this.field_11863);
            if (recipe.isPresent()) {
                return this.updateRecipe((IModifierWorktableRecipe)recipe.get());
            }
            this.recipeValid = false;
            this.currentMessage = class_2561.method_43473();
            this.buttons = Collections.emptyList();
            this.selectModifier(-1);
        }
        return null;
    }

    public List<ModifierEntry> getCurrentButtons() {
        if (this.field_11863 == null) {
            return Collections.emptyList();
        }
        this.getCurrentRecipe();
        return this.buttons;
    }

    public void onSlotChanged(int slot) {
        this.inventoryWrapper.refreshInput(slot);
        this.recipeValid = null;
        this.buttons = Collections.emptyList();
        this.selectModifier(-1);
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        class_1799 original = this.method_5438(slot);
        super.method_5447(slot, stack);
        if (original.method_7947() != stack.method_7947() || !class_1799.method_31577((class_1799)original, (class_1799)stack)) {
            this.onSlotChanged(slot);
        }
    }

    @Nullable
    public class_1703 createMenu(int menuId, class_1661 playerInventory, class_1657 playerEntity) {
        return new ModifierWorktableContainerMenu(menuId, playerInventory, this);
    }

    @Override
    public class_1799 calcResult(@Nullable class_1657 player) {
        IModifierWorktableRecipe recipe;
        if (this.selectedModifierIndex != -1 && (recipe = this.getCurrentRecipe()) != null && this.result != null) {
            return this.result.createStack(recipe.toolResultSize(this.inventoryWrapper, this.getCurrentButtons().get(this.selectedModifierIndex)));
        }
        return class_1799.field_8037;
    }

    @Override
    public void onCraft(class_1657 player, class_1799 resultItem, int amount) {
        if (amount == 0 || this.field_11863 == null || this.lastRecipe == null || this.result == null) {
            return;
        }
        resultItem.method_7982(this.field_11863, player, amount);
        ((ItemCraftedCallback)ItemCraftedCallback.EVENT.invoker()).onCraft(player, resultItem, (class_1263)this.inventoryWrapper);
        this.playCraftSound(player);
        this.inventoryWrapper.setPlayer(player);
        this.lastRecipe.updateInputs(this.result, this.inventoryWrapper, this.getCurrentButtons().get(this.selectedModifierIndex), !this.field_11863.field_9236);
        this.inventoryWrapper.setPlayer(null);
        class_1799 tinkerable = this.method_5438(0);
        if (!tinkerable.method_7960()) {
            int shrinkToolSlot = this.lastRecipe.toolResultSize();
            if (tinkerable.method_7947() <= shrinkToolSlot) {
                this.method_5447(0, class_1799.field_8037);
            } else {
                this.method_5447(0, ItemHandlerHelper.copyStackWithSize((class_1799)tinkerable, (int)(tinkerable.method_7947() - shrinkToolSlot)));
            }
        }
    }

    public LazyResultContainer getCraftingResult() {
        return this.craftingResult;
    }

    public ModifierWorktableContainerWrapper getInventoryWrapper() {
        return this.inventoryWrapper;
    }

    @Nullable
    public ToolStack getResult() {
        return this.result;
    }

    public class_2561 getCurrentMessage() {
        return this.currentMessage;
    }
}

